#Author: Dr.C. Sweetlin Hemalatha, Associate Professor, School of Computing Science & Engineering, VIT Chennai
#Ex8-Statistical Analysis of qualitative data
#R version 3.3.3
#RStudio version 1.2.1335
rm(list=ls())

#1.  Import the package MASS. 
library(MASS)

#2.  List the rows of data that has missing values.
print(survey[!complete.cases(survey),])

#3.  Create a data frame that contains the survey data after removing the na values.
newsurvey <- na.omit(survey)

#4.  How many male and female students participated in the survey?
gender <- newsurvey$Sex
gender_freq <- table(gender)
print(gender_freq)

#5.  How many the left and right handers are there?
write_hand <- newsurvey$W.Hnd
write_hand_freq <- table(write_hand)
print(write_hand_freq)

#6.  Find the relative frequency distribution of left and right handers and display them with the precision of two decimal places.
options(digits=1)
write_hand_relfreq <- write_hand_freq/nrow(newsurvey)
print(write_hand_relfreq)

#7.  Display the male left hander and female left hander in the column format.
left_hand=write_hand=="Left"
left_hand_data=newsurvey[left_hand,]
g <- left_hand_data$Sex
g_freq <- table(g)
print(cbind(g_freq))

#8.  What percentage of male left handers never smokes?
male_left_hand <- left_hand_data$Sex=="Male"
male_left_hand_data <- left_hand_data[male_left_hand,]
smk_never <- male_left_hand_data$Smoke=="Never"
smk_never_data <- male_left_hand_data[smk_never,]
print((nrow(smk_never_data)/nrow(male_left_hand_data))*100)
